/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.print.renderer;

import com.google.common.net.MediaType;
import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.print.export.PrintDataExcelExporter;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.PrintData;
import org.compiere.print.ReportEngine;
import org.compiere.print.layout.LayoutEngine;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.idempiere.print.renderer.IReportRenderer;
import org.idempiere.print.renderer.XLSReportRendererConfiguration;
import org.osgi.service.component.annotations.Component;

@Component(service={IReportRenderer.class}, immediate=true)
public class XLSReportRenderer
implements IReportRenderer<XLSReportRendererConfiguration> {
    private static final CLogger log = CLogger.getCLogger(XLSReportRenderer.class);

    @Override
    public String getId() {
        return "XLS";
    }

    @Override
    public String getName() {
        return Msg.getMsg(Env.getCtx(), "FileXLS");
    }

    @Override
    public String getContentType() {
        return MediaType.MICROSOFT_EXCEL.toString();
    }

    @Override
    public String getFileExtension() {
        return "xls";
    }

    @Override
    public void renderReport(ReportEngine reportEngine, XLSReportRendererConfiguration configuration) {
        try {
            this.createXLS(reportEngine, configuration.getOutputFile(), configuration.getLanguage());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new AdempiereException(e);
        }
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    private void createXLS(ReportEngine reportEngine, File outFile, Language language) throws Exception {
        LayoutEngine layout = reportEngine.getLayout();
        MPrintFormat printFormat = reportEngine.getPrintFormat();
        Boolean[] colSuppressRepeats = layout == null || layout.colSuppressRepeats == null ? LayoutEngine.getColSuppressRepeats(printFormat) : layout.colSuppressRepeats;
        Map<MPrintFormatItem, PrintData> childFormats = layout != null ? layout.getChildPrintFormatDetails() : null;
        PrintDataExcelExporter exp = new PrintDataExcelExporter(reportEngine.getPrintData(), printFormat, childFormats, colSuppressRepeats, reportEngine.getQuery());
        exp.export(outFile, language);
    }

    @Override
    public Class<XLSReportRendererConfiguration> getConfigurationType() {
        return XLSReportRendererConfiguration.class;
    }
}

